-- VMS Nuromint - Database Schema
-- MySQL / MariaDB

CREATE TABLE IF NOT EXISTS companies (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(150) NOT NULL,
  email VARCHAR(190) NOT NULL UNIQUE,
  phone VARCHAR(50) NULL,
  address VARCHAR(255) NULL,
  status ENUM('active','inactive') NOT NULL DEFAULT 'active',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  company_id INT NOT NULL,
  name VARCHAR(150) NOT NULL,
  email VARCHAR(190) NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('company_admin','staff_user') NOT NULL DEFAULT 'staff_user',
  status ENUM('active','inactive') NOT NULL DEFAULT 'active',
  last_login_at TIMESTAMP NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_company_email (company_id, email),
  CONSTRAINT fk_users_company FOREIGN KEY (company_id) REFERENCES companies(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS visitors (
  id INT AUTO_INCREMENT PRIMARY KEY,
  company_id INT NOT NULL,
  visitor_name VARCHAR(150) NOT NULL,
  visitor_phone VARCHAR(50) NULL,
  visitor_email VARCHAR(190) NULL,
  visitor_company VARCHAR(150) NULL,
  purpose VARCHAR(200) NOT NULL,
  host_name VARCHAR(150) NULL,
  id_type VARCHAR(80) NULL,
  id_number VARCHAR(120) NULL,
  vehicle_no VARCHAR(50) NULL,
  check_in_at DATETIME NOT NULL,
  check_out_at DATETIME NULL,
  status ENUM('in','out') NOT NULL DEFAULT 'in',
  photo_path VARCHAR(255) NULL,
  notes TEXT NULL,
  created_by INT NOT NULL,
  updated_by INT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  INDEX idx_company_checkin (company_id, check_in_at),
  INDEX idx_company_status (company_id, status),
  CONSTRAINT fk_visitors_company FOREIGN KEY (company_id) REFERENCES companies(id) ON DELETE CASCADE,
  CONSTRAINT fk_visitors_created_by FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT,
  CONSTRAINT fk_visitors_updated_by FOREIGN KEY (updated_by) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
