<?php
declare(strict_types=1);

$configPath = __DIR__ . '/../config/config.php';
if (!file_exists($configPath)) {
  http_response_code(500);
  echo "<h2>Config missing</h2><p>Please copy <code>config/config.example.php</code> to <code>config/config.php</code> and update values.</p>";
  exit;
}

$config = require $configPath;

require __DIR__ . '/Core/autoload.php';

// Session hardening - must be before session_start()
ini_set('session.cookie_httponly', '1');
ini_set('session.use_strict_mode', '1');
if (!empty($_SERVER['HTTPS'])) {
  ini_set('session.cookie_secure', '1');
}

App\Core\App::init($config);
