<?php use App\Core\Utils; ?>
<div class="row g-3">
  <div class="col-md-6">
    <label class="form-label">Visitor Name *</label>
    <input class="form-control" name="visitor_name" value="<?= Utils::e($v['visitor_name'] ?? '') ?>" required>
  </div>
  <div class="col-md-3">
    <label class="form-label">Phone</label>
    <input class="form-control" name="visitor_phone" value="<?= Utils::e($v['visitor_phone'] ?? '') ?>">
  </div>
  <div class="col-md-3">
    <label class="form-label">Email</label>
    <input class="form-control" name="visitor_email" type="email" value="<?= Utils::e($v['visitor_email'] ?? '') ?>">
  </div>

  <div class="col-md-6">
    <label class="form-label">Visitor Company</label>
    <input class="form-control" name="visitor_company" value="<?= Utils::e($v['visitor_company'] ?? '') ?>">
  </div>
  <div class="col-md-6">
    <label class="form-label">Purpose *</label>
    <input class="form-control" name="purpose" value="<?= Utils::e($v['purpose'] ?? '') ?>" required>
  </div>

  <div class="col-md-6">
    <label class="form-label">Host Name</label>
    <input class="form-control" name="host_name" value="<?= Utils::e($v['host_name'] ?? '') ?>">
  </div>
  <div class="col-md-3">
    <label class="form-label">ID Type</label>
    <input class="form-control" name="id_type" value="<?= Utils::e($v['id_type'] ?? '') ?>" placeholder="Aadhaar / DL / PAN">
  </div>
  <div class="col-md-3">
    <label class="form-label">ID Number</label>
    <input class="form-control" name="id_number" value="<?= Utils::e($v['id_number'] ?? '') ?>">
  </div>

  <div class="col-md-4">
    <label class="form-label">Vehicle No.</label>
    <input class="form-control" name="vehicle_no" value="<?= Utils::e($v['vehicle_no'] ?? '') ?>">
  </div>
  <div class="col-md-8">
    <label class="form-label">Notes</label>
    <input class="form-control" name="notes" value="<?= Utils::e($v['notes'] ?? '') ?>">
  </div>

  <div class="col-12">
    <div class="card bg-light border">
      <div class="card-body">
        <label class="form-label fw-semibold mb-3"><i class="bi bi-camera"></i> Photo</label>
        <div class="row g-2">
          <div class="col-md-6">
            <button type="button" class="btn btn-outline-primary w-100" id="cameraBtn">
              <i class="bi bi-camera"></i> Capture from Camera
            </button>
          </div>
          <div class="col-md-6">
            <input type="file" class="form-control" id="photoUpload" name="photo_upload" accept="image/*" onchange="previewPhoto(this)">
          </div>
        </div>

        <!-- Camera Preview Area -->
        <div id="cameraArea" style="display:none; margin-top: 15px;">
          <video id="videoPreview" autoplay playsinline style="width:100%; max-width:400px; border-radius:4px; background:#000; margin-bottom: 10px;"></video>
          <button type="button" class="btn btn-success btn-sm" id="captureBtn" style="display:none;">
            <i class="bi bi-check-circle"></i> Capture Photo
          </button>
          <button type="button" class="btn btn-secondary btn-sm" id="closeCameraBtn">
            <i class="bi bi-x-circle"></i> Close Camera
          </button>
        </div>

        <!-- Photo Preview -->
        <div id="photoPreview" class="mt-3" style="max-width: 200px;"></div>
        
        <canvas id="canvas" style="display:none;"></canvas>
        <input type="hidden" name="photo_base64" id="photoBase64">
      </div>
    </div>
  </div>
</div>

<script>
  let cameraStream = null;
  const cameraBtn = document.getElementById('cameraBtn');
  const captureBtn = document.getElementById('captureBtn');
  const closeCameraBtn = document.getElementById('closeCameraBtn');
  const videoPreview = document.getElementById('videoPreview');
  const cameraArea = document.getElementById('cameraArea');
  const canvas = document.getElementById('canvas');
  const photoBase64Input = document.getElementById('photoBase64');
  const photoPreviewDiv = document.getElementById('photoPreview');

  cameraBtn.addEventListener('click', async function(e) {
    e.preventDefault();
    
    if (cameraStream) {
      closeCam();
      return;
    }

    try {
      cameraStream = await navigator.mediaDevices.getUserMedia({ 
        video: { facingMode: 'user' },
        audio: false 
      });
      videoPreview.srcObject = cameraStream;
      cameraArea.style.display = 'block';
      captureBtn.style.display = 'inline-block';
      cameraBtn.innerHTML = '<i class="bi bi-pause-circle"></i> Close Camera';
    } catch (err) {
      alert('Camera access denied or not available. Please check browser permissions.');
      console.error(err);
    }
  });

  captureBtn.addEventListener('click', function(e) {
    e.preventDefault();
    capturePhoto();
  });

  closeCameraBtn.addEventListener('click', function(e) {
    e.preventDefault();
    closeCam();
  });

  function capturePhoto() {
    canvas.width = videoPreview.videoWidth;
    canvas.height = videoPreview.videoHeight;
    const ctx = canvas.getContext('2d');
    ctx.drawImage(videoPreview, 0, 0);
    
    const imageData = canvas.toDataURL('image/jpeg', 0.8);
    photoBase64Input.value = imageData;
    
    photoPreviewDiv.innerHTML = '<div class="alert alert-success alert-sm mb-0"><i class="bi bi-check-circle"></i> Photo captured!</div><br><img src="' + imageData + '" class="img-thumbnail" style="width:150px;">';
    
    closeCam();
  }

  function closeCam() {
    if (cameraStream) {
      cameraStream.getTracks().forEach(track => track.stop());
      cameraStream = null;
    }
    cameraArea.style.display = 'none';
    captureBtn.style.display = 'none';
    cameraBtn.innerHTML = '<i class="bi bi-camera"></i> Capture from Camera';
  }

  function previewPhoto(input) {
    if (input.files && input.files[0]) {
      const reader = new FileReader();
      reader.onload = function(e) {
        photoPreviewDiv.innerHTML = '<div class="alert alert-success alert-sm mb-0"><i class="bi bi-check-circle"></i> Photo selected!</div><br><img src="' + e.target.result + '" class="img-thumbnail" style="width:150px;">';
        photoBase64Input.value = '';
      };
      reader.readAsDataURL(input.files[0]);
    }
  }
</script>
