<?php use App\Core\Utils; ?>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="d-flex align-items-center justify-content-between">
          <div>
            <div class="text-muted small">Visitors currently inside</div>
            <div class="display-6 fw-semibold"><?= (int)($inCount ?? 0) ?></div>
          </div>
          <div class="icon-badge bg-primary-subtle text-primary">
            <i class="bi bi-person-badge"></i>
          </div>
        </div>
        <a href="<?= Utils::e($baseUrl) ?>/visitors?status=in" class="btn btn-primary btn-sm mt-3">View In Visitors</a>
      </div>
    </div>
  </div>

  <div class="col-md-8">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0">Recent check-ins</h5>
          <a href="<?= Utils::e($baseUrl) ?>/visitors/create" class="btn btn-success btn-sm">
            <i class="bi bi-plus-lg"></i> New Visitor
          </a>
        </div>
        <div class="table-responsive mt-3">
          <table class="table table-sm align-middle">
            <thead>
              <tr>
                <th>Name</th>
                <th>Purpose</th>
                <th>Check-in</th>
                <th>Status</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach (($recent ?? []) as $r): ?>
                <tr>
                  <td><?= Utils::e($r['visitor_name'] ?? '') ?></td>
                  <td><?= Utils::e($r['purpose'] ?? '') ?></td>
                  <td><?= Utils::e($r['check_in_at'] ?? '') ?></td>
                  <td><span class="badge bg-<?= ($r['status'] ?? '') === 'in' ? 'success' : 'secondary' ?>">
                    <?= Utils::e(strtoupper($r['status'] ?? '')) ?>
                  </span></td>
                </tr>
              <?php endforeach; ?>
              <?php if (empty($recent)): ?>
                <tr><td colspan="4" class="text-muted">No data yet.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
