<?php use App\Core\Utils; ?>
<div class="row justify-content-center">
  <div class="col-lg-5">
    <div class="card border-0 shadow-sm">
      <div class="card-body p-4">
        <h4 class="mb-1">Login</h4>
        <p class="text-muted mb-3">Login to manage visitors for your company.</p>
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger"><?= Utils::e($error) ?></div>
        <?php endif; ?>
        <form method="post" action="<?= Utils::e($baseUrl) ?>/login">
          <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
          <div class="mb-3">
            <label class="form-label">Company Email</label>
            <input class="form-control" name="company_email" placeholder="company@example.com" required>
          </div>
          <div class="mb-3">
            <label class="form-label">User Email</label>
            <input class="form-control" name="email" type="email" placeholder="user@example.com" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Password</label>
            <input class="form-control" name="password" type="password" required>
          </div>
          <button class="btn btn-primary w-100">Login</button>
        </form>
        <div class="text-center mt-3">
          <a href="<?= Utils::e($baseUrl) ?>/register-company">New company? Create admin account</a>
        </div>
      </div>
    </div>
  </div>
</div>
