<?php
namespace App\Models;

use App\Core\DB;

class User {
  public static function findByCompanyAndEmail(int $companyId, string $email): ?array {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE company_id=? AND email=? LIMIT 1");
    $stmt->execute([$companyId, $email]);
    $row = $stmt->fetch();
    return $row ?: null;
  }

  public static function create(array $data): int {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("INSERT INTO users (company_id,name,email,password_hash,role,status) VALUES (?,?,?,?,?, 'active')");
    $stmt->execute([$data['company_id'], $data['name'], $data['email'], $data['password_hash'], $data['role']]);
    return (int)$pdo->lastInsertId();
  }

  public static function listByCompany(int $companyId): array {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("SELECT id,name,email,role,status,created_at FROM users WHERE company_id=? ORDER BY id DESC");
    $stmt->execute([$companyId]);
    return $stmt->fetchAll();
  }

  public static function toggleStatus(int $companyId, int $userId): void {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("UPDATE users SET status = IF(status='active','inactive','active') WHERE company_id=? AND id=?");
    $stmt->execute([$companyId, $userId]);
  }

  public static function updateLastLogin(int $id): void {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("UPDATE users SET last_login_at=NOW() WHERE id=?");
    $stmt->execute([$id]);
  }
}
