<?php
namespace App\Models;

use App\Core\DB;

class Company {
  public static function create(array $data): int {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("INSERT INTO companies (name,email,phone,address,status) VALUES (?,?,?,?, 'active')");
    $stmt->execute([$data['name'], $data['email'], $data['phone'] ?? null, $data['address'] ?? null]);
    return (int)$pdo->lastInsertId();
  }

  public static function findByEmail(string $email): ?array {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("SELECT * FROM companies WHERE email=? LIMIT 1");
    $stmt->execute([$email]);
    $row = $stmt->fetch();
    return $row ?: null;
  }

  public static function find(int $id): ?array {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("SELECT * FROM companies WHERE id=? LIMIT 1");
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    return $row ?: null;
  }
}
