<?php
namespace App\Core;

class View {
  public static function render(string $viewPath, array $data=[]): void {
    $appName = App::config('APP_NAME','VMS Nuromint');
    $baseUrl = rtrim(App::config('APP_URL',''), '');
    $currentUser = Auth::user();
    $csrf = CSRF::token();
    
    // Merge all variables
    $vars = array_merge($data, compact('appName', 'baseUrl', 'currentUser', 'csrf', 'viewPath'));
    extract($vars, EXTR_SKIP);

    include __DIR__ . '/../Views/layouts/main.php';
  }

  public static function partial(string $viewPath, array $data=[]): void {
    extract($data, EXTR_SKIP);
    include __DIR__ . '/../Views/' . $viewPath . '.php';
  }
}

