<?php
namespace App\Core;

class Router {
  private array $routes = ['GET' => [], 'POST' => []];

  public function get(string $path, string $action, bool $auth=false): void {
    $this->routes['GET'][$path] = ['action'=>$action, 'auth'=>$auth];
  }

  public function post(string $path, string $action, bool $auth=false): void {
    $this->routes['POST'][$path] = ['action'=>$action, 'auth'=>$auth];
  }

  public function dispatch(): void {
    $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
    $uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
    $base = parse_url(App::config('APP_URL',''), PHP_URL_PATH);
    if ($base && str_starts_with($uri, $base)) {
      $uri = substr($uri, strlen($base)) ?: '/';
    }

    $route = $this->routes[$method][$uri] ?? null;
    if (!$route) {
      http_response_code(404);
      View::render('errors/404', ['uri'=>$uri]);
      return;
    }

    if ($route['auth'] && !Auth::check()) {
      Response::redirect('/login');
      return;
    }

    [$controller, $methodName] = explode('@', $route['action'], 2);
    $controllerClass = 'App\\Controllers\\' . $controller;

    if (!class_exists($controllerClass)) {
      http_response_code(500);
      echo "Controller not found.";
      return;
    }

    $instance = new $controllerClass();

    if (!method_exists($instance, $methodName)) {
      http_response_code(500);
      echo "Method not found.";
      return;
    }

    $instance->$methodName();
  }
}
