<?php
namespace App\Core;

class QRCode {
  /**
   * Generate QR code as Data URI (using external API)
   * Using qrserver.com API which doesn't require additional libraries
   */
  public static function generate(string $text, int $size = 200): string {
    $encoded = urlencode($text);
    return "https://api.qrserver.com/v1/create-qr-code/?size={$size}x{$size}&data={$encoded}";
  }

  /**
   * Generate QR code URL with custom parameters
   */
  public static function generateURL(int $visitorId, int $companyId): string {
    $text = "VMS|CID:{$companyId}|VID:{$visitorId}|TIME:" . time();
    return self::generate($text);
  }
}
