<?php
namespace App\Core;

use PDO;
use PDOException;

class DB {
  private static ?PDO $pdo = null;

  public static function init(string $host, string $db, string $user, string $pass): void {
    $dsn = "mysql:host={$host};dbname={$db};charset=utf8mb4";
    $options = [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false,
    ];
    try {
      self::$pdo = new PDO($dsn, $user, $pass, $options);
    } catch (PDOException $e) {
      http_response_code(500);
      echo "<h2>Database connection failed</h2><pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
      exit;
    }
  }

  public static function pdo(): PDO {
    if (!self::$pdo) throw new \RuntimeException('DB not initialized');
    return self::$pdo;
  }
}
