<?php
namespace App\Core;

use App\Models\User;

class Auth {
  public static function check(): bool {
    return !empty($_SESSION['user_id']);
  }

  public static function user(): ?array {
    if (!self::check()) return null;
    return $_SESSION['user'] ?? null;
  }

  public static function login(array $user): void {
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user'] = $user;
  }

  public static function logout(): void {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
      $params = session_get_cookie_params();
      setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
      );
    }
    session_destroy();
  }

  public static function requireAdmin(): void {
    if (!self::check()) {
      Response::redirect('/login');
      return;
    }
    $u = self::user();
    if (!$u || ($u['role'] ?? '') !== 'company_admin') {
      http_response_code(403);
      View::render('errors/403', ['message'=>'Admin access required.']);
      exit;
    }
  }
}
