<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\Auth;
use App\Core\CSRF;
use App\Core\Response;
use App\Core\Utils;
use App\Models\Visitor;

class VisitorController {
  public function index(): void {
    $u = Auth::user();
    $filters = [
      'q' => trim($_GET['q'] ?? ''),
      'status' => trim($_GET['status'] ?? ''),
    ];
    $rows = Visitor::list((int)$u['company_id'], $filters);
    View::render('visitors/index', ['visitors'=>$rows, 'filters'=>$filters]);
  }

  public function create(): void {
    View::render('visitors/create', ['error'=>null]);
  }

  public function store(): void {
    CSRF::verify();
    $u = Auth::user();

    $name = trim($_POST['visitor_name'] ?? '');
    $purpose = trim($_POST['purpose'] ?? '');
    if ($name==='' || $purpose==='') {
      View::render('visitors/create', ['error'=>'Visitor name and purpose are required.']);
      return;
    }

    $visitorData = [
      'company_id'=>(int)$u['company_id'],
      'visitor_name'=>$name,
      'visitor_phone'=>trim($_POST['visitor_phone'] ?? ''),
      'visitor_email'=>trim($_POST['visitor_email'] ?? ''),
      'visitor_company'=>trim($_POST['visitor_company'] ?? ''),
      'purpose'=>$purpose,
      'host_name'=>trim($_POST['host_name'] ?? ''),
      'id_type'=>trim($_POST['id_type'] ?? ''),
      'id_number'=>trim($_POST['id_number'] ?? ''),
      'vehicle_no'=>trim($_POST['vehicle_no'] ?? ''),
      'check_in_at'=>Utils::now(),
      'notes'=>trim($_POST['notes'] ?? ''),
      'created_by'=>(int)$u['id'],
      'photo_path'=>null
    ];

    $id = Visitor::create($visitorData);

    // Handle photo upload from file
    if (!empty($_FILES['photo_upload']['tmp_name'])) {
      $photoPath = Visitor::savePhotoFromUpload($_FILES['photo_upload'], $id, (int)$u['company_id']);
      if ($photoPath) {
        $pdo = \App\Core\DB::pdo();
        $stmt = $pdo->prepare("UPDATE visitors SET photo_path=? WHERE id=?");
        $stmt->execute([$photoPath, $id]);
      }
    }
    // Handle photo from camera (base64)
    elseif (!empty($_POST['photo_base64'])) {
      $photoPath = Visitor::savePhotoFromBase64($_POST['photo_base64'], $id, (int)$u['company_id']);
      if ($photoPath) {
        $pdo = \App\Core\DB::pdo();
        $stmt = $pdo->prepare("UPDATE visitors SET photo_path=? WHERE id=?");
        $stmt->execute([$photoPath, $id]);
      }
    }

    Response::redirect('/visitors/print?id=' . $id);
  }

  public function edit(): void {
    $u = Auth::user();
    $id = (int)($_GET['id'] ?? 0);
    $v = $id ? Visitor::find((int)$u['company_id'], $id) : null;
    if (!$v) { http_response_code(404); View::render('errors/404', ['uri'=>'/visitors/edit']); return; }
    View::render('visitors/edit', ['error'=>null, 'v'=>$v]);
  }

  public function update(): void {
    CSRF::verify();
    $u = Auth::user();
    $id = (int)($_POST['id'] ?? 0);
    if ($id<=0) { Response::redirect('/visitors'); }

    $name = trim($_POST['visitor_name'] ?? '');
    $purpose = trim($_POST['purpose'] ?? '');
    if ($name==='' || $purpose==='') {
      $v = Visitor::find((int)$u['company_id'], $id);
      View::render('visitors/edit', ['error'=>'Visitor name and purpose required.', 'v'=>$v]);
      return;
    }

    $visitor = Visitor::find((int)$u['company_id'], $id);
    $photoPath = $visitor['photo_path'] ?? null;

    // Handle photo upload from file
    if (!empty($_FILES['photo_upload']['tmp_name'])) {
      $newPhotoPath = Visitor::savePhotoFromUpload($_FILES['photo_upload'], $id, (int)$u['company_id']);
      if ($newPhotoPath) {
        $photoPath = $newPhotoPath;
      }
    }
    // Handle photo from camera (base64)
    elseif (!empty($_POST['photo_base64'])) {
      $newPhotoPath = Visitor::savePhotoFromBase64($_POST['photo_base64'], $id, (int)$u['company_id']);
      if ($newPhotoPath) {
        $photoPath = $newPhotoPath;
      }
    }

    Visitor::update([
      'id'=>$id,
      'company_id'=>(int)$u['company_id'],
      'visitor_name'=>$name,
      'visitor_phone'=>trim($_POST['visitor_phone'] ?? ''),
      'visitor_email'=>trim($_POST['visitor_email'] ?? ''),
      'visitor_company'=>trim($_POST['visitor_company'] ?? ''),
      'purpose'=>$purpose,
      'host_name'=>trim($_POST['host_name'] ?? ''),
      'id_type'=>trim($_POST['id_type'] ?? ''),
      'id_number'=>trim($_POST['id_number'] ?? ''),
      'vehicle_no'=>trim($_POST['vehicle_no'] ?? ''),
      'notes'=>trim($_POST['notes'] ?? ''),
      'photo_path'=>$photoPath,
      'updated_by'=>(int)$u['id']
    ]);

    Response::redirect('/visitors');
  }

  public function checkout(): void {
    CSRF::verify();
    $u = Auth::user();
    $id = (int)($_POST['id'] ?? 0);
    if ($id>0) {
      Visitor::checkout((int)$u['company_id'], $id, (int)$u['id']);
    }
    Response::redirect('/visitors');
  }

  public function printPass(): void {
    $u = Auth::user();
    $id = (int)($_GET['id'] ?? 0);
    $v = $id ? Visitor::find((int)$u['company_id'], $id) : null;
    if (!$v) { http_response_code(404); View::render('errors/404', ['uri'=>'/visitors/print']); return; }
    View::render('visitors/print', ['v'=>$v]);
  }

  public function exportCsv(): void {
    $u = Auth::user();
    $filters = [
      'q' => trim($_GET['q'] ?? ''),
      'status' => trim($_GET['status'] ?? ''),
    ];
    $rows = Visitor::list((int)$u['company_id'], $filters);

    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=visitors_export.csv');

    $out = fopen('php://output', 'w');
    fputcsv($out, ['ID','Visitor Name','Phone','Email','Visitor Company','Purpose','Host','Check-in','Check-out','Status']);
    foreach ($rows as $r) {
      fputcsv($out, [
        $r['id'], $r['visitor_name'], $r['visitor_phone'], $r['visitor_email'], $r['visitor_company'],
        $r['purpose'], $r['host_name'], $r['check_in_at'], $r['check_out_at'], $r['status']
      ]);
    }
    fclose($out);
    exit;
  }
}
