<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\Auth;
use App\Models\Visitor;

class DashboardController {
  public function index(): void {
    $u = Auth::user();
    $companyId = (int)$u['company_id'];
    $recent = Visitor::list($companyId, ['status'=>'in']);
    $inCount = count($recent);
    View::render('dashboard/index', [
      'inCount'=>$inCount,
      'recent'=>array_slice($recent, 0, 10),
    ]);
  }
}
