# VMS Nuromint (Multi-Company Visitor Management System)
A simple, modern, responsive Visitor Management System built for **cPanel (PHP + MySQL)**.

## Features
- Multi-company (each company registers and gets its own Admin account)
- Company Admin can create Users
- Users can Add / View / Edit / Check-out visitors
- Search, filters, visitor log
- Print-friendly visitor pass page
- Export visitor list to CSV
- Basic audit fields (created_by, updated_by, timestamps)
- Secure-by-default: password hashing, prepared statements, session hardening, CSRF tokens

## Requirements
- PHP 8.0+ (works with 7.4 but PHP 8 recommended)
- MySQL 5.7+ / MariaDB 10+
- Apache/Nginx (cPanel typical)

## Installation (cPanel)
1. Upload the project folder to your hosting (e.g., `public_html/vms`).
2. Create a MySQL database + user in cPanel and note:
   - DB_HOST, DB_NAME, DB_USER, DB_PASS
3. Import the schema:
   - Open phpMyAdmin → select your DB → Import → choose `database/schema.sql`
4. Copy config:
   - `config/config.example.php` → `config/config.php`
   - Fill DB credentials + set `APP_URL`
5. Browse:
   - `https://vms.neuromint.co.in/`

## Default roles
- `company_admin` (created during company signup)
- `staff_user` (created by company admin)

## Notes
- This is a clean starter project. You can extend:
  - Email/SMS notifications
  - QR-code check-in
  - Badge printer integration
  - NDA/e-signature
  - Watchlists & integrations

## Folder map
- `public/` Front controller and routing
- `app/` Core app (controllers, models, views)
- `config/` Configuration files
- `database/` SQL schema
- `storage/` logs (writable)

## Security checklist (recommended)
- Force HTTPS
- Set strong `APP_KEY` in config
- Set proper file permissions:
  - `storage/` writable
  - `config/config.php` not publicly readable if possible

---

© VMS Nuromint
